<?php
// public/personnel/create.php
declare(strict_types=1);
require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/layout.php';
require_once __DIR__ . '/../../includes/flash.php';

require_role('admin','hr');
global $pdo;

$errors = [];
$employee_id = $name = $position = $employee_type = $status = '';
$address = $cpnumber = $gender = $sstatus = $level = $department = $traineetype='';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    verify_csrf();
    $employee_id   = trim($_POST['employee_id'] ?? '');
    $name          = trim($_POST['name'] ?? '');
	
    $position      = trim($_POST['position'] ?? '');
    $employee_type = trim($_POST['employee_type'] ?? '');
    $status        = trim($_POST['status'] ?? '');
    $address         = trim($_POST['address'] ?? '');
    $cpnumber      = trim($_POST['cpnumber'] ?? '');
    $gender     = trim($_POST['gender'] ?? '');
    $sstatus       = trim($_POST['sstatus'] ?? '');
    $level         = trim($_POST['level'] ?? '');
	$department = trim($_POST['department'] ?? '');
    $others    = trim($_POST['other_department'] ?? '');

// If "Others" was selected, replace $department with the custom input
if ($department === 'Others' && !empty($others)) {
    $department = $others;
}else{
	   $department = trim($_POST['department'] ?? '');
}
	$traineetype   = trim($_POST['traineetype'] ?? '');
    $emploid= "56768";
    if ($name === '') $errors['name'] = 'Name is required.';
    if ($position === '') $errors['position'] = 'Position is required.';
$date=date('Y-m-d H:i:s');
    if (empty($errors)) {
        $stmt = $pdo->prepare("INSERT INTO personnel 
            (employee_id, name, position, employee_type, status, address, cpnumber, gender, sstatus, level, updated_at, department, traineetype ) 
            VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->execute([$emploid, $name, $position, $employee_type, $status, $address, $cpnumber, $gender, $sstatus, $level, $date, $department, $traineetype]);

$con = mysqli_connect("127.0.0.1","root","","ldp_db");
if (mysqli_connect_errno())
  {
  echo "Failed to connect to MySQL: " . mysqli_connect_error();
  }
  date_default_timezone_set("Asia/Manila");
//mysqli_query($con,"INSERT INTO users(name,email,password,role,status) VALUES ('$name','$taskid','$userid','$id','$techid','','$notes','','$note','','pending','$date')")or die(mysqli_error($con)); 
        set_flash('success', 'Personnel record created.');
        header('Location: /ldp/public/personnel/index.php');
        exit;
    }
}
render_header('Add Personnel', 'personnel');
?>

<div class="card">
  <div class="card-body">
    <form method="post" autocomplete="off" novalidate>
      <?= csrf_field(); ?>

      <div class="form-row">
       <!-- <div class="form-group col-md-4">
          <label class="form-required">Employee ID</label>
          <input name="employee_id" class="form-control <?= isset($errors['employee_id'])?'is-invalid':'' ?>" value="<?= htmlspecialchars($employee_id) ?>">
          <?php if(isset($errors['employee_id'])): ?><div class="invalid-feedback"><?= htmlspecialchars($errors['employee_id']) ?></div><?php endif; ?>
        </div> -->
        <div class="form-group col-md-8">
          <label class="form-required">Full Name</label>
          <input name="name" class="form-control <?= isset($errors['name'])?'is-invalid':'' ?>" value="<?= htmlspecialchars($name) ?>">
          <?php if(isset($errors['name'])): ?><div class="invalid-feedback"><?= htmlspecialchars($errors['name']) ?></div><?php endif; ?>
        </div>
	

        <div class="form-group col-md-6">
          <label class="form-required">Position/Designation</label>
          <input name="position" class="form-control <?= isset($errors['position'])?'is-invalid':'' ?>" value="<?= htmlspecialchars($position) ?>">
          <?php if(isset($errors['position'])): ?><div class="invalid-feedback"><?= htmlspecialchars($errors['position']) ?></div><?php endif; ?>
        </div>
		
        <!--<div class="form-group col-md-6">
          <label>Designation</label>
          <select name="employee_type" class="form-control">
            <option value="">— Select Type —</option>
            <option value="Faculty" <?= $employee_type==='Faculty'?'selected':'' ?>>Teaching</option>
            <option value="Non-Teaching" <?= $employee_type==='Non-Teaching'?'selected':'' ?>>Non-Teaching</option>
			 <option value="Faculty" <?= $employee_type==='Faculty'?'selected':'' ?>>Faculty</option>
			  <option value="Trainer" <?= $employee_type==='Trainer'?'selected':'' ?>>Trainer</option>
          </select>
        </div> -->



          <input type="hidden" name="status" class="form-control" value="Status">
          

          <input type="hidden" name="address" class="form-control" value="<?= htmlspecialchars($address) ?>">
    

    
        <input type="hidden" name="cpnumber" class="form-control" value="<?= htmlspecialchars($cpnumber) ?>">
      

      
      
          <input type="hidden" name="gender" class="form-control" value="<?= htmlspecialchars($gender) ?>">
		 
        
          <input type="hidden" name="sstatus" class="form-control" value="<?= htmlspecialchars($sstatus) ?>">
		  
   
		
         <div class="form-group col-md-3">
    <label>Office / College</label>
    <select name="department" id="department" class="form-control" required>
        <option value="">— Select Department —</option>
        <option value="College of Arts and Sciences">College of Arts and Sciences</option>
        <option value="College of Industrial Technology">College of Industrial Technology</option>
        <option value="College of Agriculture">College of Agriculture</option>
        <option value="College of Education">College of Education</option>
        <option value="College of Engineering">College of Engineering</option>
        <option value="Human Resources Management Office">Human Resources Management Office</option>
        <option value="Others">Others</option>
    </select>
</div>

<!-- Hidden input for "Others" -->
<div class="form-group col-md-3" id="otherInputDiv" style="display:none;">
    <label>Others Please specify</label>
    <input type="text" name="other_department" class="form-control" placeholder="Enter department">
</div>

<script>
    document.getElementById('department').addEventListener('change', function() {
        var otherDiv = document.getElementById('otherInputDiv');
        if (this.value === 'Others') {
            otherDiv.style.display = 'block';
        } else {
            otherDiv.style.display = 'none';
        }
    });
</script>

 
    <input type="hidden" name="level" class="form-control" <?= htmlspecialchars($level) ?>>
            
</div>
<br>
      <div  class="form-group col-md-3" style="height:40px;"> 
	  <br>
        <a href="/ldp/public/personnel/index.php" class="btn btn-outline-secondary"><i class="fas fa-arrow-left"></i> Back</a>
        <button class="btn btn-primary"><i class="fas fa-save"></i> Save</button>
      </div>
	  
	  
	  <br></br>
	  <br></br>
	  <br></br>
	  <br></br>
	  
    </form>
  </div>
</div>

<?php render_footer(); ?>
